<?php
/**
 * Avalex System Plugin
 *
 * @author     avalex GmbH
 * @package   Avalex
 * @copyright Copyright 2018-03-20 11:25:56
 * @license   GNU Public License
 * @link      http://avalex.de
 */

// No direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\String\StringHelper;

// We need the factory class which helps us to determine all supported adapters by the used server
if (!class_exists('JHttpFactory')) {
    include(JPATH_ROOT . DIRECTORY_SEPARATOR.'plugins'.DIRECTORY_SEPARATOR.'system'.DIRECTORY_SEPARATOR.'avalex'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'jhttpfactory.php');
}

/**
 * System Plugin Replaces the shortcode {avalex} with which the plugin content
 *
 * @package Avalex
 */
class PlgSystemAvalex extends JPlugin
{
    /**
     * Event method onAfterRender
     *
     * @return  void
     */

    /**
     * Application object
     *
     * @var    JApplicationCms
     * @since  1.0
     */
    protected $app;
    public static $running;

    public function onAfterRender()
    {
        $app = JFactory::getApplication();

        if (Factory::getApplication()->isClient('site') == false) {
            return false;
        }

        // Only render for HTML output.
        if (JFactory::getDocument()->getType() !== 'html') {
            return;
        }

        // fix joomla 2.5
        if (class_exists('JApplicationWeb') && method_exists($app, 'getBody')) {
            $body = $app->getBody();
            $mode = 'JApplicationWeb';
        } else {
            $body = JResponse::getBody();
            $mode = 'JResponse';
        }

        // Simple performance check to determine whether bot should process further.
        // edited by Guido to match new shortterms 02/2020
        // edited by Guido 01/2022 added multi-language tags
        $shortcodes = array('{avalex}',
            '{avalex_de_impressum}','{avalex_de_widerrufsbelehrung}','{avalex_de_datenschutz}','{avalex_de_agb}',
            '{avalex_en_impressum}','{avalex_en_widerrufsbelehrung}','{avalex_en_datenschutz}','{avalex_en_agb}',
            '{avalex_es_impressum}','{avalex_es_widerrufsbelehrung}','{avalex_es_datenschutz}','{avalex_es_agb}',
            '{avalex_fr_impressum}','{avalex_fr_widerrufsbelehrung}','{avalex_fr_datenschutz}','{avalex_fr_agb}',
            '{avalex_it_impressum}','{avalex_it_widerrufsbelehrung}','{avalex_it_datenschutz}','{avalex_it_agb}',
            '{avalex_nl_impressum}','{avalex_nl_widerrufsbelehrung}','{avalex_nl_datenschutz}','{avalex_nl_agb}');
        $avalex_page = false;
        foreach ($shortcodes as $shortcode) {
            if (stristr($body, $shortcode) !== false) {
                $avalex_page = true;
            }
        }
        if ($avalex_page) {
            $this->_replace($body, $this->params);
            switch ($mode) {
                case 'JResponse':
                    JResponse::setBody($body);
                    break;
                default:
                    $app->setBody($body);
            }
        } else {
            unset($body);
        }

    }

    public function avalexCache()
    {
        $cache = JFactory::getCache('avalex');
        $callback = array($this, 'avalex_front_view');

        $content = $cache->call($callback);
        return $content;
    }

    protected function _replace(&$text, &$params)
    {
        //$domain = $params->get('domain');
        $apikey = $params->get('apikey');

        /*
         * Check for presence of {avalex} which is explicits disables this
         * bot for the item.
         */
        if (strlen($apikey) < 2) {
            $text = StringHelper::str_ireplace('{avalex}', '', $text);
            self::$running = false;
            return true;
        }

        self::$running = true;

        $result = $this->avalex_front_view($apikey);

        if (count($result) > 0) { 
            foreach($result as $key => $value) {
                $text = StringHelper::str_ireplace($key, $value, $text);
            }
            // edited by guido 04/2021
            //            return true;
        }
        $text = StringHelper::str_ireplace('{avalex}', '', $text);

        // moved by guido 04/2021 sync after rendering

        $cron_time = ($result['cron_time']);
        $q_cron_time = time();
        if ($cron_time) {
            // jimport('joomla.utilities.date');
            $q_cron_time = JFactory::getDate($cron_time)->toUnix();
            $dif = time() - $q_cron_time;
        } else {
            $dif = 21600;
        }

        // 4 times a day
        if ($dif >= 21600) {
            $server_data = $this->getAvalexfieldCodeStatus($apikey);
//            if (!empty($server_data)) {
//                $result = $server_data;
//            }
        }

        return true;
    }
    /*frontend View */
    public function avalex_front_view($apikey)
    {
        $result = null;
        $db = JFactory::getDbo();
        $com_avalex = true;
        if ($com_avalex) {
            $query = $db->getQuery(true);
            $query->select('*');
            $query->from($db->quoteName('#__avalex'));
            //$query->where($db->quoteName('api_key')." = ".$db->quote($apikey));

            try {
                $db->setQuery($query);
                $q = $db->loadObject(); // If it fails, it will throw a RuntimeException

                // edited by Guido to pass cron time to output to sync after render 04/2021
                // edited by Guido 01/2022 added multi-language tags
                $result = array(
                    '{avalex}' => $q->avalex_de_datenschutz,
                    '{avalex_de_impressum}' => $q->avalex_de_impressum,
                    '{avalex_de_widerrufsbelehrung}' => $q->avalex_de_widerrufsbelehrung,
                    '{avalex_de_datenschutz}' => $q->avalex_de_datenschutz,
                    '{avalex_de_agb}' => $q->avalex_de_agb,
                    '{avalex_en_impressum}' => $q->avalex_en_impressum,
                    '{avalex_en_widerrufsbelehrung}' => $q->avalex_en_widerrufsbelehrung,
                    '{avalex_en_datenschutz}' => $q->avalex_en_datenschutz,
                    '{avalex_en_agb}' => $q->avalex_en_agb,
                    '{avalex_es_impressum}' => $q->avalex_es_impressum,
                    '{avalex_es_widerrufsbelehrung}' => $q->avalex_es_widerrufsbelehrung,
                    '{avalex_es_datenschutz}' => $q->avalex_es_datenschutz,
                    '{avalex_es_agb}' => $q->avalex_es_agb,
                    '{avalex_fr_impressum}' => $q->avalex_fr_impressum,
                    '{avalex_fr_widerrufsbelehrung}' => $q->avalex_fr_widerrufsbelehrung,
                    '{avalex_fr_datenschutz}' => $q->avalex_fr_datenschutz,
                    '{avalex_fr_agb}' => $q->avalex_fr_agb,
                    '{avalex_it_impressum}' => $q->avalex_it_impressum,
                    '{avalex_it_widerrufsbelehrung}' => $q->avalex_it_widerrufsbelehrung,
                    '{avalex_it_datenschutz}' => $q->avalex_it_datenschutz,
                    '{avalex_it_agb}' => $q->avalex_it_agb,
                    '{avalex_nl_impressum}' => $q->avalex_nl_impressum,
                    '{avalex_nl_widerrufsbelehrung}' => $q->avalex_nl_widerrufsbelehrung,
                    '{avalex_nl_datenschutz}' => $q->avalex_nl_datenschutz,
                    '{avalex_nl_agb}' => $q->avalex_nl_agb,
                    'cron_time' => $q->cron_time
                );

//                $cron_time = ($q->cron_time);
//                $q_cron_time = time();
//                if ($q->cron_time) {
//                    // jimport('joomla.utilities.date');
//                    $q_cron_time = JFactory::getDate($q->cron_time)->toUnix();
//                }
//                $dif = time() - $q_cron_time;
//                // 4 times a day
//                if ($dif >= 21600) {
//                    $server_data = $this->getAvalexfieldCodeStatus($apikey);
//                    if (!empty($server_data)) {
//                        $result = $server_data;
//                    }
//                }
            } catch (RuntimeException $e) {
                //throw new Exception($e->getMessage());
                $result = null;
            }
        }
        return $result;
    }

    private function getAvalexfieldCodeStatus($apikey)
    {
        $apikey_check = 0;
        $apikey_mess = '';

        $domain = 'https://avalex.de/api_keys/check_version.json';

        $url = $domain . '?apikey=' . rawurlencode($apikey).'&domain='.JURI::root();

        try {
            // j3
//             $apikey_request = JHttpFactory::getHttp()->get($url);
            // j4
            $apikey_request = JHttpFactory::getHttp(new JRegistry())->get($url, array());
        } catch (Exception $e) {
            return false;
        }

//        if ($apikey_request->code == 200) {
            return $this->get_avalex_data($apikey);
//        } elseif ($apikey_request->code == 204) {
//            // no new version
//            return false;
//        } else {
//            //error msg
//            return false;
//        }
    }

    // added by Guido 01/2022  multi-language tags
    private function get_avalex_domain_langs($apikey)
    {

        $xml = simplexml_load_file(JPATH_PLUGINS . '/system/avalex/avalex.xml');
        $version = $xml->version;

        $domain = 'https://avalex.de/avx-get-domain-langs';

        $url = $domain . '?apikey=' . rawurlencode($apikey).'&domain='.JURI::root()."&version=".$version;

        try {
            // j3
            //$langs_request = JHttpFactory::getHttp()->get($url);
            // j4
            $langs_request = JHttpFactory::getHttp(new JRegistry())->get($url, array());
            $langs = json_decode($langs_request->body, null, 1);

            if (empty($langs)) {
                $langs = array('de');
            }
        } catch (Exception $e) {
            $langs = array('de');
            return false;
        }

        // debug
//        $langs = array('de','en');

        return $langs;
    }

    protected function get_avalex_data($apikey)
    {
        // edited by Guido to match new shortterms 02/2020
        // edited by Guido 01/2022 added multi-language tags
        $jarticle = new stdClass();
        $langs = $this->get_avalex_domain_langs($apikey);
        $api_endpoints = array('avx-datenschutzerklaerung', 'avx-impressum', 'avx-bedingungen', 'avx-widerruf');

        // changed database to single inserts due to size limits

        $db = JFactory::getDbo();

        try {
            $query = $db->getQuery(true)
                ->delete($db->quoteName('#__avalex'))
                ->where('1');
            $db->setQuery($query);
            $db->execute();
        } catch (Exception $e) {
            return false;
        }

        $now = JFactory::getDate();
        if (version_compare(JVERSION, '3.0', 'ge')) {
            $cron_time = $now->toSql();
        } else {
            $cron_time = $now->toMysql();
        }

        try {
            $columns = array('id','cron_time','api_key');
            $values = array(1, $db->quote($cron_time), $db->quote($apikey));
            $query = $db->getQuery(true);
            $query
                ->insert($db->quoteName('#__avalex'))
                ->columns($db->quoteName($columns))
                ->values(implode(',', $values));
            $db->setQuery($query);
            $db->execute();
        } catch (Exception $e) {
            //$result = JFactory::getDbo()->updateObject('#__avalex', $jarticle, 'api_key');
            $error = true;
        }

        $jarticle->id = 1;
        $jarticle->api_key = $apikey;


        foreach ($langs as $lang) {
            foreach ($api_endpoints as $api_endpoint) {

                $domain = 'https://avalex.de/' . $api_endpoint;
                // generate url
                $params = http_build_query(array(
                    'apikey' => $apikey,
                    'domain' => JURI::root(),
                    'lang' => $lang
                ), '', '&');

                $url_check = $domain . '?' . $params;

                try {
                    // j3
                    // $apikey_request = JHttpFactory::getHttp()->get($url_check);
                    // j4
                    $apikey_request = JHttpFactory::getHttp(new JRegistry())->get($url_check, array());

                } catch (Exception $e) {
                    return -1;
                }
                if (!empty($apikey_request)) {
                    //$data = $apikey_request->body;
                    switch ($api_endpoint) {
                        case 'avx-datenschutzerklaerung':
                            $shortterm = "avalex_".$lang."_datenschutz";
                            if($lang === "de") { $jarticle->avalex_data = $apikey_request->body; }
                            break;
                        case 'avx-impressum':
                            $shortterm = "avalex_".$lang."_impressum";
                            break;
                        case 'avx-bedingungen':
                            $shortterm = "avalex_".$lang."_agb";
                            $jarticle->$shortterm = $apikey_request->body;
                            break;
                        case 'avx-widerruf':
                            $shortterm = "avalex_".$lang."_widerrufsbelehrung";
                            $jarticle->$shortterm = $apikey_request->body;
                            break;
                    }
                    $jarticle->$shortterm = $apikey_request->body;

                    // split database insert due to size
                    try {
                        $fields = array(
                            $db->quoteName($shortterm) . ' = ' . $db->quote($apikey_request->body)
                        );
                        $conditions = array(
                            $db->quoteName('id') . ' = 1'
                        );
                        $query = $db->getQuery(true);
                        //$result = JFactory::getDbo()->insertObject('#__avalex', $jarticle);
                        $query
                            ->update($db->quoteName('#__avalex'))
                            ->set($fields)
                            ->where($conditions);
                        $db->setQuery($query);
                        $db->execute();
                    } catch (Exception $e) {
                        //$result = JFactory::getDbo()->updateObject('#__avalex', $jarticle, 'api_key');
                        $error = true;
//                        echo $e;
                    }

                }
            }
        }

//        try {
//            $query = $db->getQuery(true);
//            $result = JFactory::getDbo()->insertObject('#__avalex', $jarticle);
//        } catch (Exception $e) {
//            //$result = JFactory::getDbo()->updateObject('#__avalex', $jarticle, 'api_key');
//            return false;
//        }

        return $apikey_request->body;
    }

} // END CLASS
