<?php
/**
 * Avalex System Plugin
 *
 * @author     avalex GmbH
 * @package   Avalex
 * @copyright Copyright 2018-03-20 11:25:56
 * @license   GNU Public License
 * @link      http://avalex.de
 */


defined('JPATH_PLATFORM') or die;

// We need the factory class which helps us to determine all supported adapters by the used server
if(!class_exists('JHttpFactory'))
{
	include (JPATH_ROOT . DIRECTORY_SEPARATOR.'plugins'.DIRECTORY_SEPARATOR.'system'.DIRECTORY_SEPARATOR.'avalex'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'jhttpfactory.php');
}

 if (version_compare(JVERSION, '3.0', 'ge')) {

	 define('AVALEX_V','3');

 }else {
   define('AVALEX_V','2_5');
   JHtml::script(JURI::root() . 'plugins/system/avalex/helpers/jquery-1.8.3.min.noconflict.js');
 }

//JHtml::_('jquery.framework');
use Joomla\Registry\Registry;

JFormHelper::loadFieldClass('text');

/**
 * Form Field class for  avalex GmbH Joomla! Extensions.
 * Provides a avalexfield code check.
 * JFormFieldText
 */
class JFormFieldAvalexfieldCodeCheck extends JFormFieldText
{
    protected $type = 'avalexfieldcodecheck';

    protected function getInput()
    {
        $field_set = $this->form->getFieldset();
        $apikey = '';

        $domain = 'https://avalex.de/api_keys/is_configured.json';

        $apikey = $this->value;
        if ($apikey === '') {
            return parent::getInput();
        }
        //$this->id = 'jform_params_apikey'

        $session = JFactory::getSession();

        $this->addHeadData();

        $session->clear('field_value', 'avalexfieldcodecheck');

        $field_value_session = $session->get('field_value', '', 'avalexfieldcodecheck');

        $apikey_session = $session->get('apikey', '', 'avalexfieldcodecheck');

        $session->clear('field_value', 'avalexfieldcodecheck');
        $session->clear('apikey', 'avalexfieldcodecheck');

        $session->set('apikey', $apikey, 'avalexfieldcodecheck');

        $apikey_mess = $apikey_check = null;
        $apikey_ress = $this->getAvalexfieldCodeStatus($domain, $apikey);
        //$apikey_check = -2;
        if (is_array($apikey_ress)) {
            $apikey_check = array_shift($apikey_ress);
            if (is_array($apikey_ress)) {
                $apikey_mess = current($apikey_ress);
            }
        } elseif (is_numeric($apikey_ress)) {
            $apikey_check = $apikey_ress;
        }

        if ($apikey_check !== 1) {
            $error = 'error';
            $text = JText::sprintf('PLG_AVALEX_APIKEY_CHECK_DEFAULT_ERROR', $apikey);

            if ($apikey_check === -1) {
                $text = JText::_('PLG_AVALEX_APIKEY_CHECK_ERROR_SERVER');
                $error = 'warning';
            }

            if ($apikey_check === -2) {
                $text = JText::_('PLG_AVALEX_APIKEY_CHECK_ERROR');
                $error = 'warning';
            }

            if ($apikey_mess) {
                $text = $apikey_mess;
            }

            $field_value = $this->setInput($text, $error);

            $session->set('field_value', $field_value, 'avalexfieldcodecheck');

            return $field_value;
        }

        $field_value = '';

        if ($this->id == 'jform_params_apikey' or $this->id == 'jform_apikey') {
            $text = JText::_('PLG_AVALEX_APIKEY_CHECK_SUCCESS');
            if ($apikey_mess) {
                $text = $apikey_mess;
            }
            $field_value .= $this->setInput($text, 'success');
        }

        $session->set('field_value', 1, 'avalexfieldcodecheck');

        return $field_value;
    }

    /**
     * Check the entered avalexfield code with the validation script that is located on a main and a fall back server
     *
     * @param $host
     * @param $apikey
     *
     * @return int|string
     */
    private function getAvalexfieldCodeStatus($host, $apikey)
    {
        $domain = 'https://avalex.de/api_keys/is_configured.json';
        $apikey_check = 0;
        $apikey_mess = JText::sprintf('PLG_AVALEX_APIKEY_CHECK_DEFAULT_ERROR', $apikey);

        $url = $host . '?apikey=' . rawurlencode($apikey).'&domain='.JURI::root();

        if (version_compare(JVERSION, '3.0', '>=')) {

            if (JHttpFactory::getAvailableDriver(new Registry) == false) {
                $apikey_mess = JText::_('PLG_AVALEX_APIKEY_CHECK_ERROR');
                return array(-2, $apikey_mess);
            }
        } else {

            if (JHttpFactory::getAvailableDriver(new JRegistry) == false) {
                $apikey_mess = JText::_('PLG_AVALEX_APIKEY_CHECK_ERROR');
                return array(-2, $apikey_mess);
            }
        }


        if (!empty($host) and !empty($apikey)) {
            // First try it with the main validation server and with HTTPS
            $url_check = $url;

            try {
                // j3
                // $apikey_request = JHttpFactory::getHttp()->get($url_check);
                // j4
                $apikey_request = JHttpFactory::getHttp(new JRegistry())->get($url_check, array());
            } catch (Exception $e) {
                $apikey_mess = JText::_('PLG_AVALEX_APIKEY_CHECK_ERROR_SERVER');
                return array(-1, $apikey_mess);
                //return -1;
            }

            $data = json_decode($apikey_request->body, true);

            if (empty($data)) {
                $apikey_mess = JText::sprintf('PLG_AVALEX_APIKEY_CHECK_DEFAULT_ERROR', $apikey);
                $apikey_check = -3;
                return array(-3, $apikey_mess);
            }

            /**JHttpResponse::__set_state(array( 'code' => 200, 'headers' => array ( 'Date' => 'Mon, 19 Mar 2018 14:33:56 GMT', 'Server' => 'Apache', 'Set-Cookie' => 'CAKEPHP=04d38d26b08aca5392fa9d6aaa6f4aa7; expires=Mon, 19-Mar-2018 18:33:56 GMT; Max-Age=14400; path=/; secure; HttpOnly', 'Upgrade' => 'h2,h2c', 'Connection' => 'Upgrade', 'Content-Length' => '36', 'Content-Type' => 'application/json; charset=UTF-8', ), 'body' => '{"message":"OK","domain":"l-one.de"}', )) */

            $currentHost = JUri::getInstance()->getHost();

            if ($apikey_request->code == 200) {

                $avalex_domain = $check_domain = false;
                if (isset($data['domain'])) {
                    $avalex_domain = ($data['domain']);
                    if (strpos($currentHost, $avalex_domain) !== false) {
                        $check_domain = true;
                    }
                }

                $is_localhost = (bool) ($currentHost == 'localhost' || $currentHost == '127.0.0.1');

                if (($check_domain || $is_localhost)) {
                    // do not show error
                } else {

                    // clear all data - for wrong domain
                    $db = JFactory::getDbo();

                    try {
                        $query = $db->getQuery(true)
                            ->delete($db->quoteName('#__avalex'))
                            ->where('1');
                        $db->setQuery($query);
                        $db->execute();
                    } catch (Exception $e) {
                        return false;
                    }

                    $apikey_mess = JText::sprintf('PLG_AVALEX_APIKEY_CHECK_DOMAIN_ERROR', $avalex_domain);
                    return array(-4, $apikey_mess);
                }
            }

            if ($apikey_request->code == 200) {
                $this->get_avalex_data($apikey);
                $apikey_check = 1;
                $apikey_mess = JText::_('PLG_AVALEX_APIKEY_CHECK_SUCCESS');
                return array($apikey_check, $apikey_mess);
            }
        }

        return array($apikey_check, $apikey_mess);
    }

    // added by Guido 01/2022  multi-language tags
    private function get_avalex_domain_langs($apikey)
    {

        $xml = simplexml_load_file(JPATH_PLUGINS . '/system/avalex/avalex.xml');
        $version = $xml->version;

        $domain = 'https://avalex.de/avx-get-domain-langs';

        $url = $domain . '?apikey=' . rawurlencode($apikey).'&domain='.JURI::root()."&version=".$version;

        try {
            // j3
            //$langs_request = JHttpFactory::getHttp()->get($url);
            // j4
            $langs_request = JHttpFactory::getHttp(new JRegistry())->get($url, array());
            $langs = json_decode($langs_request->body, null, 1);

            if (empty($langs)) {
                $langs = array('de');
            }
        } catch (Exception $e) {
            $langs = array('de');
            return false;
        }

        return $langs;
    }

    private function get_avalex_data($apikey)
    {
        // edited by Guido to match new shortterms 02/2020
        // edited by Guido 01/2022 added multi-language tags
        $jarticle = new stdClass();
        $langs = $this->get_avalex_domain_langs($apikey);
        $api_endpoints = array('avx-datenschutzerklaerung', 'avx-impressum', 'avx-bedingungen', 'avx-widerruf');

        // changed database to single inserts due to size limits

        $db = JFactory::getDbo();

        try {
            $query = $db->getQuery(true)
                ->delete($db->quoteName('#__avalex'))
                ->where('1');
            $db->setQuery($query);
            $db->execute();
        } catch (Exception $e) {
            return false;
        }

        $now = JFactory::getDate();
        if (version_compare(JVERSION, '3.0', 'ge')) {
            $cron_time = $now->toSql();
        } else {
            $cron_time = $now->toMysql();
        }

        try {
            $columns = array('id','cron_time','api_key');
            $values = array(1, $db->quote($cron_time), $db->quote($apikey));
            $query = $db->getQuery(true);
            $query
                ->insert($db->quoteName('#__avalex'))
                ->columns($db->quoteName($columns))
                ->values(implode(',', $values));
            $db->setQuery($query);
            $db->execute();
        } catch (Exception $e) {
            //$result = JFactory::getDbo()->updateObject('#__avalex', $jarticle, 'api_key');
            $error = true;
        }

        $jarticle->id = 1;
        $jarticle->api_key = $apikey;


        foreach ($langs as $lang) {
            foreach ($api_endpoints as $api_endpoint) {

                $domain = 'https://avalex.de/' . $api_endpoint;
                // generate url
                $params = http_build_query(array(
                    'apikey' => $apikey,
                    'domain' => JURI::root(),
                    'lang' => $lang
                ), '', '&');

                $url_check = $domain . '?' . $params;

                try {
                    // j3
                    // $apikey_request = JHttpFactory::getHttp()->get($url_check);
                    // j4
                    $apikey_request = JHttpFactory::getHttp(new JRegistry())->get($url_check, array());

                } catch (Exception $e) {
                    return -1;
                }
                if (!empty($apikey_request)) {
                    //$data = $apikey_request->body;
                        switch ($api_endpoint) {
                            case 'avx-datenschutzerklaerung':
                                $shortterm = "avalex_".$lang."_datenschutz";
                                if($lang === "de") { $jarticle->avalex_data = $apikey_request->body; }
                                break;
                            case 'avx-impressum':
                                $shortterm = "avalex_".$lang."_impressum";
                                break;
                            case 'avx-bedingungen':
                                $shortterm = "avalex_".$lang."_agb";
                                $jarticle->$shortterm = $apikey_request->body;
                                break;
                            case 'avx-widerruf':
                                $shortterm = "avalex_".$lang."_widerrufsbelehrung";
                                $jarticle->$shortterm = $apikey_request->body;
                                break;
                        }
                    $jarticle->$shortterm = $apikey_request->body;

                    // split database insert due to size
                    try {
                        $fields = array(
                            $db->quoteName($shortterm) . ' = ' . $db->quote($apikey_request->body)
                        );
                        $conditions = array(
                            $db->quoteName('id') . ' = 1'
                        );
                        $query = $db->getQuery(true);
                        //$result = JFactory::getDbo()->insertObject('#__avalex', $jarticle);
                        $query
                            ->update($db->quoteName('#__avalex'))
                            ->set($fields)
                            ->where($conditions);
                        $db->setQuery($query);
                        $db->execute();
                    } catch (Exception $e) {
                        //$result = JFactory::getDbo()->updateObject('#__avalex', $jarticle, 'api_key');
                        $error = true;
//                        echo $e;
                    }

                }
            }
        }

//        try {
//            $query = $db->getQuery(true);
//            $result = JFactory::getDbo()->insertObject('#__avalex', $jarticle);
//        } catch (Exception $e) {
//            //$result = JFactory::getDbo()->updateObject('#__avalex', $jarticle, 'api_key');
//            return false;
//        }
        if(@$error) {
            return false;
        }
    }

    /**
     * Creates random classes for the div containers
     *
     * @param        $session
     * @param string $type
     *
     * @return string
     */
    private function headData($type = 'error')
    {
        $head_data = '<style type="text/css"><!--

		.avalex {
		    padding-right: 20.5px !important;
		}

		.controls {
		    position: relative;
		}

		#hidestpmes {
		    width: 240px;
		    position: relative;
		}

		#jform_params_apikey {
		    width: 210px;
		}

		.avalex-feedback {
		    right: 15px;
		}

		span.icon-notification {
		    color: #993300;
		}

		.avalex-feedback {
		    position: absolute !important;
		    top: -30px !important;
		    right: 0 !important;
		    z-index: 2 !important;
		    display: block !important;
		    width: 34px !important;
		    height: 34px !important;
		    line-height: 34px !important;
		    text-align: center !important;
		    pointer-events: none !important;
		}

		#cliizyb3 {
		    padding: 0;
		    padding-top: 5px;
		    position: absolute !important;
		    z-index: 102 !important;
		    width: 99% !important;
		}

		#cliizyb2_5 {
		    padding: 0;
		    padding-top: 8px;
		    position: absolute !important;
		    z-index: 102 !important;
		    width: 99% !important;
		    height: 30px;
		    top: 50px !important;
		}

		';
		if(AVALEX_V=='2_5') {
        /*#hidestpmes{height: 60px!important;width: 448px;}*/
		$head_data .= '
		#jform_params_apikey {width: 210px; height: 16px;}
		.status_warning {
			background: url('. JURI::root() . 'plugins/system/avalex/helpers/icon-16-logout.png)  100% 0px no-repeat;
			top: 7px!important;
		}
		.status_success{
			background: url('. JURI::root() . 'plugins/system/avalex/helpers/icon-16-check.png)  100% 0px no-repeat;
			top: 7px!important;
		}
		.status_error {
			background: url('. JURI::root() . 'plugins/system/avalex/helpers/icon-16-alert.png)  100% 0px no-repeat;
			top: 7px!important;
		}
		';
		}
		$head_data .= '	--></style>';

        $head_data .= '<script type="text/javascript"><!--
		   jQuery(document).ready(function($) {
			   $("#jform_params_apikey").keyup(function() {
				  $("#hideallaval").hide();
			   })
            });
            //--></script>';

        return $head_data;
    }

    private function setInput($text = '', $type = 'error')
    {

		$class = $this->element['class'] ? (string) $this->element['class'] : '';
		//class="input-medium avalex required"

        $res = '';
        $icon = '<span class="icon-publish avalex-feedback">&nbsp;</span>';
        $css = 'color: #008002;';
        if ($type == 'error') {
			//icon-16-alert
            $icon = '<span class="icon-unpublish avalex-feedback">&nbsp;</span>';
            $css = 'color: #ff0033;';
            // add new class
			$this->element['class']=$class.' status_error';

        } elseif ($type == 'success') {
			//icon-16-messages-add
            $icon = '<span class="icon-publish avalex-feedback">&nbsp;</span>';
            $css = 'color: #008002;';
            // add new class

			$this->element['class']=$class.' status_success';

        } elseif ($type == 'warning') {
			//icon-16-messages-read
            $icon = '<span class="icon-notification avalex-feedback">&nbsp;</span>';
            $css = 'color: #8a6d3b;';
            // add new class
			$this->element['class']=$class.' status_warning';
        }
        if ($text) {
            $res = '<div id="cliizyb'.AVALEX_V.'" class="cliizyb" style="' . $css . '">' . $text . '</div><div class="clearfix"></div>';
        }

		$html = parent::getInput();

        $html = $html . '<div id="hideallaval"><div id="hidestpmes">' . $icon . '</div>' . $res . '</div>';

        return $html;
    }

    /**
     * Add the style data to the head
     *
     * @param $data
     */
    private function addHeadData($data = null)
    {
        static $data_loaded = false;

        if (empty($data_loaded)) {
            if (is_null($data)) {
                $data = $this->headData();
            }
            $document = JFactory::getDocument();
            $document->addCustomTag($data);

            $data_loaded = true;
        }
    }
} //end class
