<?php

/**
 * @file: installscript.php
 * @package:    avalex_v2.8_no_clicklegal
 * @created:    Tue May 08 2018
 * @version:    1.0.0
 * @author     avalex GmbH
 * @package   Avalex
 * @copyright Copyright 2018-03-20 11:25:56
 * @license   GNU Public License
 * @link      http://avalex.de
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Script file of BwPostman module
 *
 * @since       2.0.0
 */
class PlgSystemAvalexInstallerScript
{

    /**
     * Construction
     */
    public function __construct()
    {
        /* Load language */
        $lang = JFactory::getLanguage();
        $lang->load('plg_system_avalex', JPATH_ADMINISTRATOR);
    }
    /**
     * method to install the component
     * @param object $parent Parent object
     * @return void
     */
    public function install($parent)
    {

    }
    /**
     * method to uninstall the component
     * @param object $parent Parent object
     * @return void
     */
    public function uninstall($parent)
    {

    }
    /**
     * method to update the component
     * @param object $parent Parent object
     * @return void
     */
    public function update($parent)
    {

    }
    /**
     * method to run before an install/update/uninstall method
     * @param type $type
     * @param object $parent Parent object
     * @return void
     */
    public function preflight($type, $parent)
    {

    }
    /**
     * Method to run after an install/update/uninstall method
     * @uses
     * Postflight is executed after the Joomla install, update or discover_update actions have completed.
     * It is not executed after uninstall.
     * Postflight is executed after the extension is registered in the database.
     * The type of action (install, update or discover_install) is passed to postflight in the $type operand.
     * Postflight cannot cause an abort of the Joomla install, update or discover_install action.
     * @param string $type
     * @param type $parent
     */
    public function postflight($type, $parent)
    {
        /* Only enable plugin on install/update */
        if ($type !== 'install' && $type !== 'update') {
            return;
        }

        /* Enable plugin */
        $db = JFactory::getDbo();
        $query = 'UPDATE ' . $db->quoteName('#__extensions') . ' SET ' . $db->quoteName('enabled') . ' = 1 WHERE ' . $db->quoteName('type') . ' = ' . $db->quote('plugin') . ' AND ' . $db->quoteName('element') . ' = ' . $db->quote('avalex');
        $db->setQuery($query);
        $db->execute();

        $install = "
		CREATE TABLE `#__avalex` (
		  `id` INT( 11 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
		  `cron_time` DATETIME NULL DEFAULT NULL,
		  `api_key` varchar(255) NULL DEFAULT NULL,
		  `avalex_data` longtext NULL DEFAULT NULL,
		  `avalex_de_impressum` longtext NULL DEFAULT NULL,
		  `avalex_de_widerrufsbelehrung` longtext NULL DEFAULT NULL,
		  `avalex_de_datenschutz` longtext NULL DEFAULT NULL,
		  `avalex_de_agb` longtext NULL DEFAULT NULL,
		  `avalex_en_impressum` longtext NULL DEFAULT NULL,
		  `avalex_en_widerrufsbelehrung` longtext NULL DEFAULT NULL,
		  `avalex_en_datenschutz` longtext NULL DEFAULT NULL,
		  `avalex_en_agb` longtext NULL DEFAULT NULL,		  
		  `avalex_es_impressum` longtext NULL DEFAULT NULL,
		  `avalex_es_widerrufsbelehrung` longtext NULL DEFAULT NULL,
		  `avalex_es_datenschutz` longtext NULL DEFAULT NULL,
		  `avalex_es_agb` longtext NULL DEFAULT NULL,		  
		  `avalex_fr_impressum` longtext NULL DEFAULT NULL,
		  `avalex_fr_widerrufsbelehrung` longtext NULL DEFAULT NULL,
		  `avalex_fr_datenschutz` longtext NULL DEFAULT NULL,
		  `avalex_fr_agb` longtext NULL DEFAULT NULL,		  
		  `avalex_it_impressum` longtext NULL DEFAULT NULL,
		  `avalex_it_widerrufsbelehrung` longtext NULL DEFAULT NULL,
		  `avalex_it_datenschutz` longtext NULL DEFAULT NULL,
		  `avalex_it_agb` longtext NULL DEFAULT NULL,
		  `avalex_nl_impressum` longtext NULL DEFAULT NULL,
		  `avalex_nl_widerrufsbelehrung` longtext NULL DEFAULT NULL,
		  `avalex_nl_datenschutz` longtext NULL DEFAULT NULL,
		  `avalex_nl_agb` longtext NULL DEFAULT NULL,		  
		  `avalex_msg` varchar(255) NULL DEFAULT NULL,
		  `avalex_domain` varchar(255) NULL DEFAULT NULL,
		  UNIQUE `uniqueapikey` ( `api_key` ( 20 ) )
		) ;
		";

        $update = "";

        switch($type) {
            case 'install':
                $db->setQuery($install);
                $db->execute();
                break;
            case 'update':
//                $db->setQuery($update);
                break;
        }

        $columns = $db->getTableColumns('#__avalex');

        if (!isset($columns['avalex_domain'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_domain` varchar(255) NULL DEFAULT NULL';
            $db->setQuery($query);
            $db->execute();
        }
        // 2.0.0
        if (!isset($columns['avalex_de_impressum'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_de_impressum` longtext NULL DEFAULT NULL AFTER `avalex_data`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_de_datenschutz'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_de_datenschutz` longtext NULL DEFAULT NULL AFTER `avalex_de_impressum`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_de_agb'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_de_agb` longtext NULL DEFAULT NULL AFTER `avalex_de_datenschutz`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_de_widerrufsbelehrung'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_de_widerrufsbelehrung` longtext NULL DEFAULT NULL AFTER `avalex_de_agb`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_en_impressum'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_en_impressum` longtext NULL DEFAULT NULL AFTER `avalex_de_widerrufsbelehrung`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_en_datenschutz'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_en_datenschutz` longtext NULL DEFAULT NULL AFTER `avalex_en_impressum`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_en_agb'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_en_agb` longtext NULL DEFAULT NULL AFTER `avalex_en_datenschutz`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_en_widerrufsbelehrung'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_en_widerrufsbelehrung` longtext NULL DEFAULT NULL AFTER `avalex_en_agb`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_es_impressum'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_es_impressum` longtext NULL DEFAULT NULL AFTER `avalex_en_widerrufsbelehrung`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_es_datenschutz'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_es_datenschutz` longtext NULL DEFAULT NULL AFTER `avalex_es_impressum`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_es_agb'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_es_agb` longtext NULL DEFAULT NULL AFTER `avalex_es_datenschutz`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_es_widerrufsbelehrung'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_es_widerrufsbelehrung` longtext NULL DEFAULT NULL AFTER `avalex_es_agb`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_fr_impressum'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_fr_impressum` longtext NULL DEFAULT NULL AFTER `avalex_es_widerrufsbelehrung`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_fr_datenschutz'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_fr_datenschutz` longtext NULL DEFAULT NULL AFTER `avalex_fr_impressum`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_fr_agb'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_fr_agb` longtext NULL DEFAULT NULL AFTER `avalex_fr_datenschutz`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_fr_widerrufsbelehrung'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_fr_widerrufsbelehrung` longtext NULL DEFAULT NULL AFTER `avalex_fr_agb`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_it_impressum'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_it_impressum` longtext NULL DEFAULT NULL AFTER `avalex_fr_widerrufsbelehrung`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_it_datenschutz'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_it_datenschutz` longtext NULL DEFAULT NULL AFTER `avalex_it_impressum`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_it_agb'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_it_agb` longtext NULL DEFAULT NULL AFTER `avalex_it_datenschutz`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_it_widerrufsbelehrung'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_it_widerrufsbelehrung` longtext NULL DEFAULT NULL AFTER `avalex_it_agb`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_nl_impressum'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_nl_impressum` longtext NULL DEFAULT NULL AFTER `avalex_it_widerrufsbelehrung`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_nl_datenschutz'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_nl_datenschutz` longtext NULL DEFAULT NULL AFTER `avalex_nl_impressum`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_nl_agb'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_nl_agb` longtext NULL DEFAULT NULL AFTER `avalex_nl_datenschutz`';
            $db->setQuery($query);
            $db->execute();
        }
        if (!isset($columns['avalex_nl_widerrufsbelehrung'])) {
            $query = $db->getQuery(true);
            $query = 'ALTER TABLE `#__avalex` ADD `avalex_nl_widerrufsbelehrung` longtext NULL DEFAULT NULL AFTER `avalex_nl_agb`';
            $db->setQuery($query);
            $db->execute();
        }

        $columns = array_keys($db->getTableColumns('#__avalex'));
        $important = array('api_key','avalex_de_impressum','avalex_de_widerrufsbelehrung','avalex_de_datenschutz','avalex_de_agb','avalex_en_impressum','avalex_en_widerrufsbelehrung','avalex_en_datenschutz','avalex_en_agb',
            'avalex_es_impressum','avalex_es_widerrufsbelehrung','avalex_es_datenschutz','avalex_es_agb','avalex_fr_impressum','avalex_fr_widerrufsbelehrung','avalex_fr_datenschutz','avalex_fr_agb',
            'avalex_it_impressum','avalex_it_widerrufsbelehrung','avalex_it_datenschutz','avalex_it_agb','avalex_nl_impressum','avalex_nl_widerrufsbelehrung','avalex_nl_datenschutz','avalex_nl_agb');
        $check = true;
        foreach($important as $key => $value) {
            if(!in_array($value, $columns)) {
                $check = false;
            }
        }

        $datetimes = array('cron_time');
        $varchars = array('api_key','avalex_msg','avalex_domain');
        $longtexts = array('avalex_data','avalex_de_impressum','avalex_de_widerrufsbelehrung','avalex_de_datenschutz','avalex_de_agb','avalex_en_impressum','avalex_en_widerrufsbelehrung','avalex_en_datenschutz','avalex_en_agb',
            'avalex_es_impressum','avalex_es_widerrufsbelehrung','avalex_es_datenschutz','avalex_es_agb','avalex_fr_impressum','avalex_fr_widerrufsbelehrung','avalex_fr_datenschutz','avalex_fr_agb',
            'avalex_it_impressum','avalex_it_widerrufsbelehrung','avalex_it_datenschutz','avalex_it_agb','avalex_nl_impressum','avalex_nl_widerrufsbelehrung','avalex_nl_datenschutz','avalex_nl_agb');
        $drops = array('avalex_en_imprint','avalex_en_cancellation','avalex_en_privacy','avalex_en_terms');

        foreach($datetimes as $column) {
            $query = $db->getQuery(true);
            $db->setQuery("ALTER TABLE `#__avalex` CHANGE `".$column."` `".$column."` DATETIME NULL DEFAULT NULL");
            $db->execute();
        }

        foreach($varchars as $column) {
            $query = $db->getQuery(true);
            $db->setQuery("ALTER TABLE `#__avalex` CHANGE `".$column."` `".$column."` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL");
            $db->execute();
        }

        foreach($longtexts as $column) {
            $query = $db->getQuery(true);
            $db->setQuery("ALTER TABLE `#__avalex` CHANGE `" . $column . "` `" . $column . "` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL");
            $db->execute();
        }

        foreach($drops as $column) {
            if(in_array($column, $columns)) {
                $query = $db->getQuery(true);
                $db->setQuery("ALTER TABLE `#__avalex` DROP `" . $column . "`");
                $db->execute();
            }
        }

//        $query = $db->getQuery(true);
//        $query
//            ->select($db->quoteName(array('api_key')))
//            ->from($db->quoteName('#__avalex'));
//        $db->setQuery($query);
//        $apikey = $db->loadResult();

        $plugin = JPluginHelper::getPlugin('system', 'avalex');
        if ($plugin)
        {
            $pluginParams = new JRegistry($plugin->params);
            $apikey = $pluginParams->get('apikey');
        } else {
            $apikey = false;
        }

        $query = $db->getQuery(true);
        $query
            ->select($db->quoteName(array('enabled')))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
            ->where($db->quoteName('element') . ' = ' . $db->quote('avalex'));
        $db->setQuery($query);
        $enabled = $db->loadResult();

        if($check) {
            JFactory::getApplication()->enqueueMessage('Installationsstatus: erfolgreich', 'message');

            if($apikey) {
                JFactory::getApplication()->enqueueMessage('API Key ist eingetragen: '.$apikey, 'message');

                if($enabled) {
                    JFactory::getApplication()->enqueueMessage('Plugin ist veröffentlicht', 'message');
                } else {
                    JFactory::getApplication()->enqueueMessage('Plugin ist nicht veröffentlicht<br>(Bitte Plugin <a href="/administrator/index.php?option=com_plugins&view=plugins&filter_search=avalex">aktivieren</a>.)', 'error');
                }

            } else {
                JFactory::getApplication()->enqueueMessage('API Key fehlt.<br>(Bitte in den <a href="/administrator/index.php?option=com_plugins&view=plugins&filter_search=avalex">Plugin-Einstellungen</a> eintragen.)', 'error');
            }

        } else {
            JFactory::getApplication()->enqueueMessage('Installationsstatus: fehlerhaft<br>(Bitte Plugin deinstallieren und neu installieren. Ihr Api Key lautet: '.$apikey.')', 'error');
        }

        echo "<br>Sie können die Einstellungen des Plugins <a href=\"/administrator/index.php?option=com_plugins&view=plugins&filter_search=avalex\">hier verwalten</a>.";


    }
} // END CLASS
